/**
 * @file buchi.h
 * @brief Description of Buchi automata for LTL verification algorithms.
 * @date 12 sep 2017
 * @author Sami Evangelista
 *
 * The implementation of the Buchi automaton (buchi.c) is generated by
 * ltl2ba.
 */

#ifndef LIB_BUCHI
#define LIB_BUCHI

#include "common.h"
#include "includes.h"
#include "model.h"


/**
 * @typedef a state of a Buchi automaton
 */
typedef int bstate_t;


/**
 * @struct an event of a Buchi automaton is identified by its source
 *         and destination states
 */
typedef struct {
  bstate_t from;
  bstate_t to;
} bevent_t;


/**
 * @brief Return the initial state of the Buchi automaton.
 */
bstate_t bstate_initial
();


/**
 * @brief Check if the state is accepting.
 */
bool_t bstate_accepting
(bstate_t b);


/**
 * @brief Get successors of state b synchronised with the model state
 *        s.  Return in succs the list of successors and in no_succs
 *        the number of successors.
 */
void bstate_succs
(bstate_t b,
 mstate_t s,
 bstate_t * succs,
 unsigned int * no_succs);


/**
 * @brief Compares two events.
 */
order_t bevent_cmp
(bevent_t e,
 bevent_t f);

#endif
